{* modules/Users/views/Login.php *}

{strip}

<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<link href="https://fonts.googleapis.com/css?family=Montserrat" rel="stylesheet">
	<title> CRM Login </title>
</head>

	<style>
		#page{
			padding-top:0%;
			margin:0% !important;
		}
		body {
			font-family: 'Montserrat', sans-serif;
			font-size:14px;
		}

		.mt-30{
			margin-top:30px;
		}

		.mt-50{
			margin-top:50px;
		}

		.login-bckgrd{
			width:100%;
			height:100%;
			background:url("layouts/v7/modules/CustomLogin/templates/red_fruit/background.jpeg");
			background-size:cover; 
			position:absolute;
		}

		.container{
			width:30%;
			margin:auto;
			background:#fff;
			margin-top:10%;
			border-radius:30px;
			padding:30px;
		}

		.text-center{
			text-align:center;
		}

		.login{
			width:100%;
			border:none;
			font-family: 'Montserrat', sans-serif;
			border-bottom:1px solid lightgray;
			font-size:16px;
			padding:5px;
			overflow:hidden;
		}

		.help{
			text-decoration:none;
			font-size:14px;
			float:right;
		}

		.help:hover{
			text-decoration:underline;
			color:#911710;
		}

		.back{
			text-decoration:none;
			font-size:14px;
			float:right;
			cursor:pointer !important;
		}

		.back:hover{
			text-decoration:underline;
			color:#911710;
		}

		.btn-login{
			border:1px solid #911710;
			border-radius:50px;
			width:30%;
			background:#911710;
			color:white;
			padding:10px;
			font-size:15px;
		}

		.btn-login:hover{
			border-color:#710904;
			background:#710904;
			cursor:pointer;
		}

		.fa{
			font-size:30px !important;
			text-align:center;
			color:#911710;
		}

		.ico{
			margin-top:0px;
			margin-left:35%;
			margin:auto;
			text-align:center;
		}

		.bar {
		  position: relative;
		  display: block;
		  width: 100%;
		}
		.bar:before {
		  content: "";
		  position: absolute;
		  left: 50%;
		  right: 50%;
		  bottom: 0;
		  background:#e86830;
		  height: 2px;
		  -webkit-transition: left 0.3s ease-out, right 0.3s ease-out;
		  transition: left 0.3s ease-out, right 0.3s ease-out;
		}

		.login:focus ~ .bar:before {
		  left: 0;
		  right: 0;
		}

		:required:invalid{
			box-shadow:none;
		}
		.bck-grd{
			width:100%;
			height:100%;
			background-size:cover;
			background:rgba(0,0,0,0.5);
			position:absolute;
		}
		
		@media screen and (max-width:360px){
			.container{
				min-width:95%;
				margin:auto;
				margin-top:20% !important;
				padding:20px;
			}
			.ico{
				margin-left:33%;
				margin-top:-22%;
			}
		}

		@media screen and (max-width:768px){
			.container{
				width:60%;
				margin:auto;
				margin-top:10%;
			}
		}

	</style>
<body>
<div id="page">
	<div class="login-bckgrd">
	<div class="bck-grd">
		<div class="container" id="loginDiv">
		<div id="signin">
		    <div class="ico">
                <img src="{$COMPANY_LOGO}">
			</div>
			<form class="form-register" style="margin:0;" action="index.php?module=Users&action=Login" method="POST">
			
				{if isset($smarty.request.error)}
					<div class="alert alert-error">
					<p>Invalid username or password.</p>
					</div>
				{/if}
				
				{if isset($smarty.request.fpError)}
					<div class="alert alert-error">
					<p>Invalid Username or Email address.</p>
					</div>
				{/if}
				
				{if isset($smarty.request.statusError)}
					<div class="alert alert-error">
					<p>Outgoing mail server was not configured.</p>
					</div>
				{/if}
												
				{if isset($smarty.request.status)}
					<div class="alert alert-success">
					<p>Mail was send to your inbox, please check your e-mail.</p>
					</div>
				{/if}
			
				<div class="mt-30">
				<div class="control-group">
					<label for="username">User name</label>
					<input type="text" class="login" id="username" name="username" required>
					<span class="bar"></span>
				</div>
				</div>
				<div class="mt-30">
				<div class="control-group">
					<label for="password">Password</label>
					<input type="password" class="login" id="password" name="password" required>
					<span class="bar"></span>
				</div>
				</div>
			
			<div class="mt-30">
			<div class="controls" id="forgotPassword">
			<input type="checkbox"> Remember me
			<a class="help" href="">Forgot Password?</a>
			</div>
			</div>
			<div class="text-center mt-50">
				<button type="submit" class="btn-login">LOGIN</button>
			</div>
			</form>
			</div>
			
			<div id="forgotPasswordDiv">
			<div id="forgot" style="display:none;">
			<div class="ico">
				<span class="fa fa-newspaper-o"></span>
			</div>
				<form class="form-register"  action="forgotPassword.php"  method="POST">
							
				{if isset($smarty.request.error)}
					<div class="alert alert-error">
					<p>Invalid username or password.</p>
					</div>
				{/if}
				
				{if isset($smarty.request.fpError)}
					<div class="alert alert-error">
					<p>Invalid Username or Email address.</p>
					</div>
				{/if}
				
				{if isset($smarty.request.statusError)}
					<div class="alert alert-error">
					<p>Outgoing mail server was not configured.</p>
					</div>
				{/if}
												
				{if isset($smarty.request.status)}
					<div class="alert alert-success">
					<p>Mail was send to your inbox, please check your e-mail.</p>
					</div>
				{/if}
				
				<h3 class="login-header text-center">Forgot Password</h3>
				
				<div class="mt-30">
				<div class="control-group">
					<label for="username">User name</label>
					<input type="text" class="login" id="username" name="username" required>
					<span class="bar"></span>
				</div>
				</div>
				<div class="mt-30">
				<div class="control-group">
					<label for="email">Email</label>
					<input type="text" class="login" id="emailId" name="emailId" required>
					<span class="bar"></span>
				</div>
				</div>
				<div class="control-group signin-button">
				<div class="mt-50">
				<div class="controls" id="backButton">
					<button type="submit" class="btn-login">Submit</button>
					<a href="" class="back">Back to Login</a>
				</div>
				</div>
				</div>
				</form>
			</div>
			</div>
		</div>
		</div>
	</div>
</div>
</body>

<script>
jQuery(document).ready(function(){
	jQuery('.help').focus(function(){
		jQuery("#signin").hide();
		jQuery("#forgot").show();
	});
	jQuery('.back').focus(function(){
		jQuery("#signin").show();
		jQuery("#forgot").hide();
	});

			
			jQuery("input[name='retrievePassword']").click(function (){
				var username = jQuery('#user_name').val();
				var email = jQuery('#emailId').val();
								var email1 = email.replace(/^\s+/,'').replace(/\s+$/,'');
				var emailFilter = /^[^@]+@[^@.]+\.[^@]*\w\w$/ ;
				var illegalChars= /[\(\)\<\>\,\;\:\\\"\[\]]/ ;
				
				if(username == ''){
					alert('Please enter valid username');
					return false;
				} else if(!emailFilter.test(email1) || email == ''){
					alert('Please enter valid email address');
					return false;
				} else if(email.match(illegalChars)){
					alert( "The email address contains illegal characters.");
					return false;
				} else {
					return true;
				}
				
			});
});
</script>

</html>
{/strip}
