{* modules/Users/views/Login.php *}

{strip}
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<link href="https://fonts.googleapis.com/css?family=Poppins:200,300,400,700" rel="stylesheet">
	<title> CRM Login </title>
</head>
	<style>
		#page{
			padding-top:0%;
		}
		body{
			font-family: 'Poppins', sans-serif;
			font-weight:300 !important;
			font-size:16px;
		}

		.login-form{
			width:100%;
			background:url("layouts/v7/modules/CustomLogin/templates/beach/background.jpeg");
			background-size:cover;
			height:100%;
			color:white;
			position:absolute !important;
		}
		
		.bck-grd{
			width:100%;
			height:100%;
			background-size:cover;
			background:rgba(0,0,0,0.1);
			position:absolute;
		} 
			
		.text-center{
		  text-align: center;
		}

		.container {
			width:33%;
			margin:auto;
			margin-top:10%;
			padding:0px;
			z-index:1000;
			opacity:1 !important;
		}

		.login {
			padding: 20px;
			background:transparent;
			color:#f9f9f9;
		}

		.done, .done:focus{
		  font-family: 'Poppins', sans-serif;
		  background:transparent;
		  color:white;
		  padding:10px;
		  border:2px solid white;
		  border-radius:50px;
		  width:150px;
		  font-size:16px !important;
		  margin-top:30px;
		  font-weight:700;
		}

		.done:hover{
		  background-color: #fff;
		  color:black;
		  cursor:pointer;
		  transition:all 1s;
		}

		.mt-30{
			margin-top:30px;
		}

		.help .help:focus{ 
			font-size:16px;
			color:white;
			text-decoration:none;
		}

		.help:hover{
			color:#bcbaba;
		}
		
		.signin {
		  position: relative;
		  width:100%;
		  margin-bottom: 30px;
		}
		.signin input {
			font-family: 'Poppins', sans-serif;
			font-weight:400 !important;
		  border: none;
		  border-bottom: 1px solid #bcbaba;
		  padding:10px;
		  display: block;
		  width:100%;
		  background:transparent;
		  overflow:hidden;
		  font-size:16px !important;
		  color:#fff;
		}
		.signin input:focus {
		  outline: none;
		}
		.signin input:focus ~ label, .signin input:valid ~ label {
		  top: -10px;
		  font-size: 14px;
		  color:#bcbaba;
		}
		.signin label {
		font-family: 'Poppins', sans-serif;
			font-weight:400 !important;
		  position: absolute;
		  color: #fff;
		  top: 12px;
		  left: 0;
		  -webkit-transition: 0.2s ease all;
		  transition: 0.2s ease all;
		}

		.bar {
		  position: relative;
		  display: block;
		  width: 100%;
		}
		.bar:before {
		  content: "";
		  position: absolute;
		  left: 50%;
		  right: 50%;
		  bottom: 0;
		  background:#fff;
		  height: 2px;
		  -webkit-transition: left 0.5s ease-out, right 0.5s ease-out;
		  transition: left 0.5s ease-out, right 0.5s ease-out;
		}

		input:focus ~ .bar:before {
		  left: 0;
		  right: 0;
		}

		:required:invalid{
			box-shadow:none;
		}
		.align-left{
			float:left;
		}
		
		@media screen and (max-width: 360px){
			.container{
				width:80%;
				margin-top:20%;
				overflow:hidden;
			}
		}

		@media screen and (min-width: 768px) and (max-width: 980px) {
		 .container{
				width:60%;
				overflow:hidden; 
			} 
		}
	</style>
	    <script src="libraries/jquery/jquery.min.js"></script>
		<script src="libraries/jquery/boxslider/jquery.bxslider.js"></script>
		<script src="libraries/jquery/boxslider/jquery.bxslider.min.js"></script>
		<script src="libraries/jquery/boxslider/respond.min.js"></script>
		<script>
			jQuery(document).ready(function(){
				scrollx = jQuery(window).outerWidth();
				window.scrollTo(scrollx,0);
				slider = jQuery('.bxslider').bxSlider({
				auto: true,
				pause: 4000,
				randomStart : true,
				autoHover: true
			});
			jQuery('.bx-prev, .bx-next, .bx-pager-item').live('click',function(){ slider.startAuto(); });
			}); 
		</script>

<body>
<div id="page"> 
	<div class="login-form">
	<div class="bck-grd">
		<div class="container">
			<div class="text-center"><img src="{$COMPANY_LOGO}"></div>
			<div class="login"  id="loginDiv">
				<form class="form-register" style="margin:0;" action="index.php?module=Users&action=Login" method="POST">
					{if isset($smarty.request.error)}
						<div class="alert alert-error">
						<p>Invalid username or password.</p>
						</div>
					{/if}
					
					{if isset($smarty.request.fpError)}
						<div class="alert alert-error">
						<p>Invalid Username or Email address.</p>
						</div>
					{/if}
					
					{if isset($smarty.request.statusError)}
						<div class="alert alert-error">
						<p>Outgoing mail server was not configured.</p>
						</div>
					{/if}
												
					{if isset($smarty.request.status)}
						<div class="alert alert-success">
						<p>Mail was send to your inbox, please check your e-mail.</p>
						</div>
					{/if}
					
					<div class="signin control-group">      
					  <input type="text" id="username" name="username" required>
					  <span class="bar"></span>
					  <label for="username">Username</label>
					</div>
					<div class="signin">      
					  <input type="password" id="password" name="password" required>
					  <span class="bar"></span>
					  <label for="password">Password</label>
					</div>
					<div class="control-group">
					<div  class="controls" id="forgotPassword">
					<div class="text-center">
					<button type="submit" class="done">LOGIN</button>
					</div>
					<div class="text-center mt-30"><a class="help" href="#">Forgot your password?</a></div>
					</div>
					</div>
				</form>
			</div>
			
			<div class="login"   id="forgotPasswordDiv" style="display:none;">
				<form class="form-register"  action="forgotPassword.php"  method="POST">
					
					{if isset($smarty.request.error)}
						<div class="alert alert-error">
						<p>Invalid username or password.</p>
						</div>
					{/if}
					
					{if isset($smarty.request.fpError)}
						<div class="alert alert-error">
						<p>Invalid Username or Email address.</p>
						</div>
					{/if}
					
					{if isset($smarty.request.statusError)}
						<div class="alert alert-error">
						<p>Outgoing mail server was not configured.</p>
						</div>
					{/if}
												
					{if isset($smarty.request.status)}
						<div class="alert alert-success">
						<p>Mail was send to your inbox, please check your e-mail.</p>
						</div>
					{/if}
					
					<h3 class="login-header text-center">Forgot Password</h3>
					
					<div class="signin control-group mt-30">      
					  <input type="text" id="username" name="username" required>
					  <span class="bar"></span>
					  <label for="username">Username</label>
					</div>
					<div class="signin">      
					  <input type="text" id="emailId" name="emailId" required>
					  <span class="bar"></span>
					  <label for="email">Email</label>
					</div>
					<div class="control-group">
					<div  class="controls" id="forgotPassword">
					<div class="text-center">
					<button type="submit" class="done" name="retrievePassword">Submit</button>
					</div>
					<div class="text-center mt-30"><a class="help" href="">Back to Login</a></div>
					</div>
					</div>
				</form>
			</div>
			
		</div>
	</div>
</div>
</div>
</body>

<script>
	jQuery(document).ready(function(){
	jQuery("#forgotPassword a").click(function() {
	/*console.log('djnhr');*/										
	jQuery("#loginDiv").hide();
	jQuery("#forgotPasswordDiv").show();											
	});
	
	jQuery("#backButton a").click(function() {
	jQuery("#loginDiv").show();
	jQuery("#forgotPasswordDiv").hide();
	});
			
	jQuery("input[name='retrievePassword']").click(function (){
	var username = jQuery('#user_name').val();
	var email = jQuery('#emailId').val();
	var email1 = email.replace(/^\s+/,'').replace(/\s+$/,'');
	var emailFilter = /^[^@]+@[^@.]+\.[^@]*\w\w$/ ;
	var illegalChars= /[\(\)\<\>\,\;\:\\\"\[\]]/ ;
				
	if(username == ''){
	alert('Please enter valid username');
	return false;
	} else if(!emailFilter.test(email1) || email == ''){
	alert('Please enter valid email address');
	return false;
	} else if(email.match(illegalChars)){
	alert( "The email address contains illegal characters.");
	return false;
	} else {
	return true;
	}
			
	});
	});
	</script>
		
</html>
