<?php
/* +**********************************************************************************
 * The contents of this file are subject to the JoForce Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Developer of the Original Code is JoForce.
 * All Rights Reserved.
 * ********************************************************************************** */

class SmackGraphql {

	public function vtlib_handler($moduleName, $eventType){

		global $root_directory, $log,$adb;
		if($eventType == 'module.postinstall'){

			//======================FORSETTINGS=================================
			$fieldid = $adb->getUniqueID('vtiger_settings_field');
			$blockid = getSettingsBlockId('LBL_OTHER_SETTINGS');
			$seq_res = $adb->pquery("SELECT max(sequence) AS max_seq FROM vtiger_settings_field WHERE blockid = ?", array($blockid));
			$seq = 1;
			if ($adb->num_rows($seq_res) > 0) {
				$cur_seq = $adb->query_result($seq_res, 0, 'max_seq');
				if ($cur_seq != null) {
					$seq = $cur_seq + 1;
				}
			}
			$adb->pquery('INSERT INTO vtiger_settings_field(fieldid, blockid, name, iconpath, description, linkto, sequence)
				VALUES (?,?,?,?,?,?,?)', array($fieldid, $blockid, 'SmackGraphql', '', 'Api for Mobile apps',
					'index.php?module=SmackGraphql&parent=Settings&view=List', $seq));

			//==================================================================

			$adb->pquery("CREATE TABLE IF NOT EXISTS `vtiger_smack_graphql` (`id` int(10) NOT NULL AUTO_INCREMENT,`info` text,PRIMARY KEY (`id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8", array());

			if (!extension_loaded('zip')){
				$adb->pquery('insert into vtiger_smack_graphql (info) values(?)', array("Zip Extension is not installed"));
				return;
			}

			$backup_result = copy($root_directory.'index.php',$root_directory.'index_backup.php');
			if($backup_result == true){
				$result = copy($root_directory.'modules/SmackGraphql/dependencies.zip', $root_directory.'dependencies.zip');
				if($result == true){
					$file = $root_directory.'dependencies.zip';
					$file_path = $root_directory;
					$zip = new ZipArchive;
					$res = $zip->open($file);
					if ($res === TRUE) {
						$zip_extract = $zip->extractTo($file_path);
						if ($zip_extract == false) {
							$adb->pquery('insert into vtiger_smack_graphql (info) values(?)', array("Unable to Extract Zip file"));
							return;
						}
						$zip->close();
						$adb->pquery("DROP TABLE IF EXISTS `vtiger_smack_graphql`", array());
						$adb->pquery("CREATE TABLE IF NOT EXISTS `vtiger_smack_graphql` (`id` int(10) NOT NULL AUTO_INCREMENT,`info` text,PRIMARY KEY (`id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8", array());
					}else{
						$adb->pquery('insert into vtiger_smack_graphql (info) values(?)', array("Unable to open zip file"));
					}
				}
				else{
					$adb->pquery('insert into vtiger_smack_graphql (info) values(?)', array("dependencies.zip not copied-change permission"));
				}
			}else{
				$adb->pquery('insert into vtiger_smack_graphql (info) values(?)', array("Index.php not copied-please change permission"));
			}

		}elseif ($eventType == 'module.postupdate') {

			$backup_result = copy($root_directory.'index.php',$root_directory.'index_backup.php');
			if($backup_result == true){
				$result = copy($root_directory.'modules/SmackGraphql/dependencies.zip', $root_directory.'dependencies.zip');
				if($result == true){
					$file = $root_directory.'dependencies.zip';
					$file_path = $root_directory;
					$zip = new ZipArchive;
					$res = $zip->open($file);
					if ($res === TRUE) {
						$zip_extract = $zip->extractTo($file_path);
						if ($zip_extract == false) {
							$adb->pquery('insert into vtiger_smack_graphql (info) values(?)', array("Unable to Extract Zip file"));
							return;
						}
						$zip->close();
						$adb->pquery("DROP TABLE IF EXISTS `vtiger_smack_graphql`", array());
						$adb->pquery("CREATE TABLE IF NOT EXISTS `vtiger_smack_graphql` (`id` int(10) NOT NULL AUTO_INCREMENT,`info` text,PRIMARY KEY (`id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8", array());
					}else{
						$adb->pquery('insert into vtiger_smack_graphql (info) values(?)', array("Unable to open zip file"));
					}
				}
				else{
					$adb->pquery('insert into vtiger_smack_graphql (info) values(?)', array("dependencies.zip not copied-change permission"));
				}
			}else{
				$adb->pquery('insert into vtiger_smack_graphql (info) values(?)', array("Index.php not copied-please change permission"));
			}
		}
	}
}
