<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/
//Overrides GetRelatedList : used to get related query
//TODO : Eliminate below hacking solution
include_once 'config.php';
include_once 'include/Webservices/Relation.php';
include_once 'vtlib/Vtiger/Module.php';
include_once 'includes/main/WebUI.php';
require_once 'vendor/autoload.php';
require_once 'api/graphql/Vtiger/GraphQL.php';
require_once 'api/graphql/Vtiger/VtigerHelper.php';
use Vtiger\GraphQL;
use Vtiger\VtigerHelper;
require_once 'include/utils/utils.php';
require_once 'config.inc.php';
require_once 'includes/main/WebUI.php'; 

if(isset($_REQUEST["api"])) {
	if ($_REQUEST["api"] == "graphql_version") {
		$response_data = ['success' => true, 'message' => 'v2.0'];
		echo json_encode($response_data);
		return;
	} elseif ($_REQUEST["api"] == "oauth") {
		$username = trim($_POST['username']);
  		$password = trim($_POST['password']);
		global $application_unique_key;
		//If credentials are not passed, return error
		if(empty($username) || empty($password))  {
			$message  = ['success' => false,'message' => 'username and password can not be empty'];
			header('HTTP/1.0 401 Unauthorized'); 
			echo json_encode($message);
			return;
		} 

		//Check credentials are valid
		$current_user = CRMEntity::getInstance('Users');
		$current_user->column_fields['user_name'] = $username; 

		// If credentials are wrong, return
		if(!$current_user->doLogin($password))  {
			$response_data = ['success' => false, 'message' => 'Authentication invalid'];
			header('HTTP/1.0 401 Unauthorized'); 
			echo json_encode($response_data);
			return;
		}

		$current_user->id = $current_user->retrieve_user_id($username); 

		$current_user->retrieveCurrentUserInfoFromFile($current_user->id);  
		$issued_at = time();  

		$jwt_data = [
		'iat'  => $issued_at,
		'jti'  => base64_encode(generateRandomString(30)),
		'iss'  => $container['environment']['SERVER_NAME'],
		'exp'  => $issued_at + 866400,
		'data' => [
			'userId'   => $current_user->id,
			'userName' => $username,
			'user_timezone' => $current_user->time_zone,
			'user_currency' => $current_user->currency_code,
			'user_currency_id' => fetchCurrency($current_user->id),
			'version_type' => 'Pro',
			'date_format' => $current_user->date_format,
			]
		];  
		$refresh_token = \Firebase\JWT\JWT::encode($jwt_data, $application_unique_key);
		$access_token = access_token($refresh_token , $application_unique_key);

		$response_data = ['success' => true, 'refresh_token' => $refresh_token,'access_token' => $access_token ,'date_format' =>$current_user->date_format];

		echo json_encode($response_data);
		return;
	} elseif ($_REQUEST["api"] == "refresh_token") {
		global $application_unique_key;
		$access_token = access_token($_REQUEST['refresh_token'], $application_unique_key);
  		$response_data = ['success' => true, 'access_token' => $access_token ,'date_format' =>$current_user->date_format];
  		echo json_encode($response_data);
  		return;
	} elseif ($_REQUEST["api"] == "authorize") {
		global $application_unique_key;
		// If credentials are not passed, return error
		if(empty($_REQUEST['username']) || empty($_REQUEST['password']))  {
			$message  = ['success' => false,'message' => 'username and password can not be empty'];
			header('HTTP/1.0 401 Unauthorized'); 
			echo json_encode($message);
			return;
		}

	    // Check credentials are valid
		$current_user = CRMEntity::getInstance('Users');
		$current_user->column_fields['user_name'] = $_REQUEST['username'];

	    // If credentials are wrong, return
		if(!$current_user->doLogin($_REQUEST['password']))  {
			$response_data = ['success' => false, 'message' => 'Authentication invalid'];
			header('HTTP/1.0 401 Unauthorized'); 
			echo json_encode($response_data);
			return;
		}
		$current_user->id = $current_user->retrieve_user_id($_REQUEST['username']);
		$current_user->retrieveCurrentUserInfoFromFile($current_user->id);
		$issued_at = time();
		$jwt_data = [
			'iat'  => $issued_at,
			'jti'  => base64_encode(generateRandomString(30)),
			'iss'  => $container['environment']['SERVER_NAME'],
			'exp'  => $issued_at + 86400,
			'data' => [
				'userId'   => $current_user->id,
				'userName' => $_REQUEST['username'],
				'crm_timezone' => DateTimeField::getDBTimeZone(),
				'user_timezone' => $current_user->time_zone,
				'user_currency' => $current_user->currency_code,
				'user_currency_id' => fetchCurrency($current_user->id),
				'version_type' => 'Pro',
				'date_format' => $current_user->date_format,
			]
		];

		$token = \Firebase\JWT\JWT::encode($jwt_data, $application_unique_key);
		$response_data = ['success' => true, 'token' => $token,'date_format' =>$current_user->date_format];
		echo json_encode($response_data);
		return; 
	}elseif($_REQUEST["api"] == "location"){
		$requested_data = [];
		foreach ($_REQUEST as $key => $value) {
			$requested_data[$key] = $value;
		}
		$current_user = CRMEntity::getInstance('Users');
		$token = $requested_data['token'];
		try{
			$decoded = \Firebase\JWT\JWT::decode($token, $application_unique_key, array('HS256'));
		}catch(Exception $e){
			header('HTTP/1.0 401 Unauthorized'); 
			echo json_encode(['success' => 'false' ,'message' => 'Authentication invalid']); 
			die();
		}

		$vtiger_helper =  new VtigerHelper($adb, $current_user);
		$request_for_responce = $vtiger_helper->returnLocationDetails($requested_data);
		echo json_encode($request_for_responce);
		return;
	}

	elseif ($_REQUEST["api"] == "me") {
		$token = $_REQUEST['token'];
		try{
			$decoded = \Firebase\JWT\JWT::decode($token, $application_unique_key, array('HS256'));}
			catch(Exception $e){
				header('HTTP/1.0 401 Unauthorized'); 
				echo json_encode(['success' => 'false' ,'message' => 'Authentication invalid']); 
				die();
			}

			global $site_URL;
			$user_info = $decoded->data;
			$detailViewModel = \Vtiger_DetailView_Model::getInstance('Users', $user_info->userId);
			$userModel = $detailViewModel->getRecord();
			$user_image = $userModel->getImageDetails();
			$user_profile_url = null;
			if($user_image) {
				if(isset($user_image[0]['id']) && !empty($user_image[0]['id'])) {
					$user_profile_url = $site_URL . $user_image[0]['path'] . '_' . $user_image[0]['name'];
				}
			}
			$user_info->user_profile_url = $user_profile_url;
			$user_info->user_currency_id = fetchCurrency($user_info->userId);
			echo json_encode($user_info);
			return;
		} elseif ($_REQUEST["api"] == "graphql") { 
			$requested_data = [];
			foreach ($_REQUEST as $key => $value) {
				$requested_data[$key] = $value;
			}
			$current_user = CRMEntity::getInstance('Users');
			$token = $requested_data['token'];
			try {
				$decoded = \Firebase\JWT\JWT::decode($token, $application_unique_key, array('HS256'));
			} catch(Exception $e){
				header('HTTP/1.0 401 Unauthorized'); 
				echo json_encode(['success' => 'false' ,'message' => 'Authentication invalid']); 
				die();
			}
			$user_info = $decoded->data;
			$current_user->retrieveCurrentUserInfoFromFile($user_info->userId);
			
			$graphql =  new GraphQL(new VtigerHelper($adb, $current_user));  
			$queryType = $graphql->generateQueryType($requested_data);
			$mutationType = $graphql->generateMutationType($requested_data);
			$schema = $graphql->schema($queryType, $mutationType);
			$graphql_response = $graphql->execute($schema, $requested_data);
			echo json_encode($graphql_response);
			return;
		}elseif($_REQUEST["api"] == "export"){		
			if($_REQUEST['module']=='Quotes'){

				$request = array('module' => 'PDFMaker', 
				'source_module' => $_REQUEST['module'],
				'formodule' => $_REQUEST['module'],
				'view' => '',
				'record' => $_REQUEST['id'],
				'language' => $_REQUEST['language'],
				'action' => 'CreatePDFFromTemplate');

				$current_user->id = $_REQUEST['current_user']; // change using $decoded
				$checkGenerate = new PDFMaker_checkGenerate_Model();
				$checkGenerate->generate(new Vtiger_Request($request,$request));

			}else{
				$moduleName=$_REQUEST['module'];
				$recordId=$_REQUEST['id'];
			 	$recordModel = Vtiger_Record_Model::getInstanceById($recordId, $moduleName); 
	            $recordModel->getPDF();
	        }
		}		
    } else {
	$webUI = new Vtiger_WebUI();
	$webUI->process(new Vtiger_Request($_REQUEST, $_REQUEST));
}

//function to generate random string.
function generateRandomString($length = 10) {
	$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
	$charactersLength = strlen($characters);
	$randomString = '';
	for ($i = 0; $i < $length; $i++) {
		$randomString .= $characters[rand(0, $charactersLength - 1)];
	}
	return $randomString;
}

function access_token($refresh_token , $application_unique_key){ 
	$issued_at = time();  
	try {
		$decoded = \Firebase\JWT\JWT::decode($refresh_token, $application_unique_key, array('HS256'));
		$jwt_data = [
			'iat'  => $issued_at,
			'jti'  => base64_encode(generateRandomString(30)),
			'iss'  => $container['environment']['SERVER_NAME'],
			'exp'  => $issued_at + 86400,
			'data' => [
			'userId'   => $decoded->data->userId,
			'userName' => $decoded->data->userName,
			'crm_timezone' => DateTimeField::getDBTimeZone(),
			'user_timezone' => $decoded->data->user_timezone,
			'user_currency' => $decoded->data->user_currency,
			'user_currency_id' => fetchCurrency($decoded->data->userId),
			'version_type' => 'Pro',
			'date_format' => $decoded->data->date_format,
			]
		]; 
		$access_token = \Firebase\JWT\JWT::encode($jwt_data, $application_unique_key);
	} catch(Exception $e){
		header('HTTP/1.0 401 Unauthorized'); 
		echo json_encode(['success' => 'false' ,'message' => 'Authentication invalid']); 
		die();
	}
	return  $access_token ;
}
?>